%define module_name Data-Fetch
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/CleanNamespaces.pm) perl(Test/DescribeMe.pm) perl(Test/Distribution.pm) perl(Test/Kwalitee.pm) perl(Test/Most.pm) perl(Test/Needs.pm) perl(Test/NoWarnings.pm) perl(Test/Perl/Metrics/Simple.pm) perl(Test/Warn.pm) perl(threads.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: give advance warning that you'll be needing a value
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NH/NHORNE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Sometimes we know in advance that we'll be needing a value which is going to take a long time to compute or determine.
This module fetches the value in the background so that you don't need to wait so long when you need the value.

    use CalculatePi;
    use Data::Fetch;
    my $fetcher = Data::Fetch->new();
    my $pi = CalculatePi->new(places => 1000000);
    $fetcher->prime(object => $pi, message => 'as_string');_# Warn we'll run $pi->as_string() in the future
    # Do other things
    print $fetcher->get(object => $pi, message => 'as_string'), "\n";_# Runs $pi->as_string()
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes README.md LICENSE
%perl_vendor_privlib/D*

%changelog
