# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Data-FetchPath
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: "eval"able paths to your complex data values
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/O/OV/OVID/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Quick summary of what the module does.

    use Data::FetchPath 'path';
    use Test::Most;

    my $data = {
        foo => 3,
        bar => [qw/ this that 3 /],
        3   => undef,
        baz => {
            trois  => 3,
            quatre => [qw/ 1 2 3 4 /],
        }
    };
    my $target_value = 3;
    ok $paths = path( $data, $target_value ), 'Fetching paths for matching data should succeed';
    my @expected = sort qw(
      {bar}[2]
      {baz}{trois}
      {baz}{quatre}[2]
      {foo}
    );
    eq_or_diff $path, \@expected,
        '... and it should return all paths to data values found';
    for ( 0 .. $#expected ) {
        my $found_value = eval "\$data->$expected[$_]";
        is $found_value, $target_value,
            '... and all values should match the value you looked for';
        }
    }


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
