# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Data-HexConverter
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: High performance hex string to binary converter
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JK/JKSTILL/%{module_name}-%{version}.tar.gz

%description
This module provides two functions, `hex_to_binary' and
`binary_to_hex'.

`hex_to_binary' accepts a reference to a scalar containing an ASCII
hexadecimal string and returns a binary string.  It uses SSSE3
intrinsics to convert blocks of 32 characters at a time for maximum
throughput.  Remaining characters are handled via a lookup table.  If
the input contains an odd number of characters or an invalid hex
digit, an exception is thrown.

`binary_to_hex' performs the reverse operation: it accepts a
reference to a scalar containing arbitrary binary data and returns an
uppercase hexadecimal representation.  It uses SSSE3 vector
instructions to expand 16 bytes at a time but will fall back to a
scalar implementation and emit a warning if SSSE3 is not available.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README ignore.txt Changes
%perl_vendor_archlib/D*
%perl_vendor_autolib/*

%changelog
