# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Tools.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(Tie/IxHash.pm)
# END SourceDeps(oneline)
%define module_name Data-ISO8583
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.44
Release: alt1
Summary: >{ 62 }, $VISA_MESSAGE_FIELD_62 );
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CA/CADE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Data::ISO8583;
  use Data::ISO8583::VISA;
  
  my $msg_hash_ref = parse_iso8583_fields( $byte_data, $VISA_MESSAGE_FIELDS );
  
  my ( $fmap_arr_ref, $skip ) = parse_iso8583_bitmap( $byte_data, $len, $one, $base );

  my $field_62_hr = parse_iso8583_fields( $msg_hash_ref->{ 62 }, $VISA_MESSAGE_FIELD_62 );

  # field 61 has no bitmap, has only 3 fields, so to use the same parser,
  # fake bitmap has to be passed with first 3 bits set and also bitmap size
  # should be set to 1 (byte, BML) and flag raised that there is no chained bitmaps (BMO)
  my $field_61_hr = parse_iso8583_fields( chr( 0b11100000 ) . $msg_hash_ref->{ 61 }, $VISA_MESSAGE_FIELD_61, { BML => 1, BMO => 1 } );
  
  # field 60 is similar to 61 but there are 10 fields so either larger bitmap is needed (2 bytes)
  # or can be chained two 1-byte bitmaps:
  my $field_60_hr = parse_iso8583_fields( chr( 0b11111111 ) . chr( 0b01110000 ) . $msg_hash_ref->{ 60 }, $VISA_MESSAGE_FIELD_60, { BML => 1 } );

  or:

  my $field_60_hr = parse_iso8583_fields( pack( 'C2', 0b11111111, 0b01110000 ) . $msg_hash_ref->{ 60 }, $VISA_MESSAGE_FIELD_60, { BML => 1, BMB => 1 } );

  or with single bitmap of size 2 bytes without chaining:

  my $field_60_hr = parse_iso8583_fields( pack( 'C2', 0b11111111, 0b11000000 ) . $msg_hash_ref->{ 60 }, $VISA_MESSAGE_FIELD_60, { BML => 2, BMO => 1 } );
  

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING README Changes
%perl_vendor_privlib/D*

%changelog
