# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(NEXT.pm) perl(parent.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Data-Inherited
%define upstream_version 1.100860

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    Hierarchy-wide accumulation of list and hash results
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Data/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Test/Compile.pm)
BuildRequires: perl(Test/More.pm)
BuildArch: noarch
Source44: import.info


%description
NEXT.pm adds a pseudoclass named 'NEXT' to any program that uses it. If a
method 'm' calls '$self-'NEXT::m()>, the call to 'm' is redispatched as if
the calling method had not originally been found.

In other words, a call to '$self-'NEXT::m()> resumes the depth-first,
left-to-right search of '$self''s class hierarchy that resulted in the
original call to 'm'.

Note that this is not the same thing as '$self-'SUPER::m()>, which begins a
new dispatch that is restricted to searching the ancestors of the current
class. '$self-'NEXT::m()> can backtrack past the current class -- to look
for a suitable method in other ancestors of '$self' -- whereas
'$self-'SUPER::m()> cannot.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%{make}

%check
%{make} test

%install
%makeinstall_std

%files
%doc Changes LICENSE README META.yml
%perl_vendor_privlib/*

%changelog
