%define module_name Data-LNPath
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Terse.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: lookup on nested data via path
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LN/LNATION/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Data::LNPath qw/lnpath/ => { 
__errors => {  
___invalid_key => \&invalid_key,
___invalid_index => \&invalid_index,
___invalid_method => \&invalid_method,,
___allow_meth_keys => undef
__} 
_};

_my $data = {
__one => {
___a => [qw/10 20 30/],
___b => { a => 10, b => 20, c => 30 },
___c => 1
__},
__two => [qw/1 2 3/],
__three => 10,
__four => Test::Obj->new(),
_};

_lnpath($data, '/three'); # 10
_lnpath($data, 'one/a/1'); # 10;
_lnpath($data, 'one/b/a'); # 10
_lnpath($data, 'two/2/3/4'); # 2 unless you set the additional error invalid_path (make it die)
_lnpath($data, 'four/plus(10, 2)');
_lnpath($data, 'four/minus(200, crazy_world)');
_lnpath($data, 'four/plus(200, crazy_world(50))');
_lnpath($data, 'four/plus(200, &other_world(100))');
_lnpath($data, 'four/magic(200, { okay => 'fine' }, [ 1, 2, 3, should, &work ])');
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README ignore.txt Changes
%perl_vendor_privlib/D*

%changelog
