# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Digest/SHA.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Slurp.pm) perl(File/Spec.pm) perl(File/stat.pm) perl(HTTP/Date.pm) perl(IO/File.pm) perl(JSON/XS.pm) perl(LWP/Online.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(List/Util.pm) perl(POSIX.pm) perl(Test/More.pm) perl(Text/CSV_XS.pm) perl(XML/LibXML.pm) perl(YAML/XS.pm) perl(base.pm) perl(open.pm) perl(strict.pm) perl(utf8.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Data-Mirror
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: a simple way to efficiently retrieve data from the World Wide Web.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GB/GBROWN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Data::Mirror' tries to take away as much pain as possible when it comes to
retrieving and using remote data sources such as JSON objects, YAML documents,
XML instances and CSV files.

Many Perl programs need to retrieve, store, and then parse remote data
resources. This can result in a lot of repetitive code, to generate a local
filename, check to see if it already exists and is sufficiently fresh, retrieve
a copy of the remote resource if needed, and then parse it. If a program uses
data sources of many different types (say JSON, XML and CSV) then it often does
the same thing over and over again, just using different modules for parsing.

`Data::Mirror' does all that for you, so you can focus on using the data.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/D*

%changelog
