# BEGIN SourceDeps(oneline):
BuildRequires: perl(Algorithm/Permute.pm) perl(IO/File.pm) perl(Module/Build.pm) perl(Storable.pm) perl(YAML/Syck.pm)
# END SourceDeps(oneline)
%define module_name Data-Nested
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.12
Release: alt1
Summary: routines to work with a perl nested data structure
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SB/SBECK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module contains methods for working with a perl nested data
structure (NDS).  Before using this module, it is assumed that the
programmer is completely familiar with perl data structures. If this
is not the case, this module will be of very limited use. Some
suggested reading to become familiar with perl data structures is
included below in the SEE ALSO section.

A data structure may consist of any number of nested perl data types
including:

   lists
   hashes
   scalars
   other (everything else)

This module can easily perform the following operations:

=over 4

=item Access parts of the NDS

It is very easy to get a value stored somewhere in an NDS, or to set a
value somewhere in an NDS.

=item Verify structural integrity

Often, a data structure may have constraints on it (certain parts of
it may be lists, hashes, or scalars). This module can enforce those
constraints when setting parts of the NDS.

=item Merge multiple NDSs into a single NDS

Two different NDSs may be merged into a single NDS using a series of
rules (described below).

=back

A reasonably complete set of examples for how to do these and
other tasks is included below.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc HISTORY LICENSE README examples
%perl_vendor_privlib/D*

%changelog
