# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Socket.pm) perl(Test/More.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define module_name Data-Netflow
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Module to process binary netflow data (v5 and v9)
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FD/FDULAU/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Module to create netflow binary data from text data

    use Data::Netflow;
    use IO::Socket;

    my $sock_udp = IO::Socket::INET->new(
        Proto    => 'udp',
        PeerPort => 9995,
        PeerAddr => '127.0.0.1',
    ) or die "Could not create UDP socket: $!\n";

    my $TemplateV9 = {
        'FlowSetId'      => 0,
        'TemplateId' => 300,
        'Fields'   => [
            { 'Length' => 4, 'Id' => 1  },    # octetDeltaCount
            { 'Length' => 4, 'Id' => 2  },    # packetDeltaCount
            { 'Length' => 1, 'Id' => 4  },    # protocolIdentifier
            { 'Length' => 1, 'Id' => 6  },    # tcp flags
            { 'Length' => 2, 'Id' => 7  },    # sourceTransportPort
            { 'Length' => 4, 'Id' => 8  },    # sourceIPv4Address
            { 'Length' => 2, 'Id' => 11 },    # destinationTransportPort
            { 'Length' => 4, 'Id' => 12 },    # destinationIPv4Address
            { 'Length' => 4, 'Id' => 21 },    # last switched
            { 'Length' => 4, 'Id' => 22 },    # first switched
    ],
}

    my $Header = {
                 Version => 9,
                 SysUptime => int ( uptime() *1000 ),
             };


    my @flow;
    my @tmp = qw( 5 8126 17 0 22 10.2.1.1 5365 10.2.1.254  ) ;
    my $uptime = int ( (uptime()- $back ) *1000 );
    push @tmp  , $uptime + 5;
    push @tmp  , $uptime;
    push @flow , \@tmp;

    my $encoded = Data::Netflow::encodeV9($Header, $TemplateV9 ,\@flow);
    $sock_udp->send( $encoded );

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/D*

%changelog
