# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Readonly.pm) perl(Scalar/Util.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 2.1.1
%define module_name Data-Predicate
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.1.1
Release: alt1
Summary: >apply(1); #returns true
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AY/AYATES/data/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This idea of predicates is taken from 
the section on "/commons.apache.org/collections/'" in the <a href='http: manpageApache Commons collections</a>>
and the section on "/code.google.com/p/google-collections/'" in the <a href='http: manpagegoogle-collections</a>>.

Predicates are a way of composing logic so it eventually reports a true/false
for a given value. The criteria for coming up with this reponse could be
quite complex but always the answer has to be boolean. The predicates
can also do filtering of an array reference of items and do transformations
on those items when a predicate returns true.

Predicates also allow for more complex and/or statements to be built. For
example:

  use Data::Predicate::Predicates qw(:all);
  my $or_predicate = p_or(map { p_string_equals($_) } qw(a b c d e f) );
  my $and_predicate = p_and( p_defined(), $or_predicate );
  
  my $truth = $and_predicate->apply('a');
  $truth = $and_predicate->apply('d');
  $truth = $and_predicate->apply('f');
  
This is functionally equivalent to:

  my ($v) = @_;
  if(defined $v && ( $v eq 'a' || $v eq 'b' || $v eq 'c' || $v eq 'd' || $v eq 'e' || $v eq 'f')) {
    
  }

This or code will also begin to shortcut operations in the same way the above
if statement would have done.

However one word of warning is that you should not use predicates for matters
where simple logic will suffice. Do not use it when doing simple if tests
or simple list grepping. Predicates are not a Perlism and will make your
code harder to read to the un-initiated.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
