%define module_name Data-Pretty
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Module/Signature.pm) perl(Symbol.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(lib.pm) perl(overload.pm) perl(parent.pm) perl(strict.pm) perl(subs.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.9
Release: alt1
Summary: Data Dump Beautifier
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JD/JDEGUEST/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This is a fork from the Data::Dump manpage and a drop-in replacement with the aim at providing the following improvements:

=over 4

=item * Avoid long indentation matching the length of a property

For example, `Data::Dump' would produce

    {
        query => { term => { user => "kimchy" } },
        sort  => [
                     { post_date => { order => "asc" } },
                     "user",
                     { name => "desc" },
                     { age => "desc" },
                     "_score",
                 ],
    }

whereas, `Data::Pretty' would make it more crisp:

    {
        query => {
            term => { user => "kimchy" },
        },
        sort => [
            {
                post_date => { order => "asc" },
            },
            "user",
            { name => "desc" },
            { age => "desc" },
            "_score",
        ],
    }

=item * Break down structure for clarity when necessary

For example, the following structure with the Data::Dump manpage:

    { from => 0, query => { term => { user => "kimchy" } }, size => 10 }

would become, under `Data::Pretty':

    {
        from => 0,
        query => {
            term => { user => "kimchy" },
        },
        size => 10,
    }

=item * Prevent UTF-8 characters from being encoded in hexadecimal.

`Data::Dump' would encode `.'a.'e.''.'U' as `\x{30B8}\x{30E3}\x{30C3}\x{30AF}', which although correct, is not human readable.

However, not encoding in hexadecimal UTF-8 strings means that if you print it out, you will need to set the the binmode entry in the perlfunc manpage to `utf-8'. You can also use the open manpage when printing on the `STDOUT' or `STDERR':

    use open ':std' => 'utf8';

You can disable this by setting `$Data::Pretty::SHOW_UTF8' to false.

=item * Quoting hash keys

With `Data::Dump', whenever at least 1 hash key has non alphanumeric characters, it is rightfully surrounded by double quotes, but unfortunately so are all the other hash keys who do not need surrounding double quotes.

Thus,...

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README CONTRIBUTING.md LICENSE TODO CHANGES README.md
%perl_vendor_privlib/D*

%changelog
