# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Carp/Clan/Share.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(List/Enumerator.pm) perl(Module/Build.pm) perl(Moose.pm) perl(MooseX/AttributeHelpers.pm) perl(Net/FTP.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Sub/Exporter.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Data-Pulp
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Pulp your data into a consistent goop
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RK/RKRIMEN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Data::Pulp is a tool for coercing and/or validating input data. Instead of doing this:

    if ( defined $value ) {
        if ( ref $value eq ... ) {
            ...
        }
        elsif ( $value =~ m/.../ ) {
            ...
        }
        ...
    }
    else {
    }

You can do something like this:

    my $pulper = pulper
        case { $_ eq ... }  then { ... }
        case { m/.../ }     then { ... }
        nil { ... # Do action if value is undefined }
    ;

    $pulper->pulp( $value )

A pulper can act transparently on a single value, ARRAY, or HASH:

    my $set = $pulper->prepare( $value ) # A single value list
    my $set = $pulper->prepare( [ $value, ... ] )
    my $set = $pulper->prepare( { key => $value, ... } ) # Throws away the keys, basically

So, given a subroutine:

    sub method {
        my $data = shift;
        # $data could be a single value, or an array, or even a hash
        my $set = $pulper->prepare( $data )
        my @data = $set->all # Get all the data coerced how you want
                             # or throw an exception if something bad is encountered

        ...
    }


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
