# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dump.pm) perl(Data/Dumper.pm) perl(Data/Random/Structure.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Data-Random-Structure-UTF8
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Produce nested data structures with unicode keys, values, elements.
Group: Development/Perl
License: artistic_2
URL: https://metacpan.org/module/Data::Random::Structure::UTF8

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BL/BLIAKO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module produces random, arbitrarily deep and long,
nested Perl data structures  with unicode content for the
keys, values and/or array elements. Content can be forced
to be exclusively strings and exclusively unicode. Or
the strings can be unicode. Or anything goes, mixed
unicode and non-unicode strings as well as integers, floats, etc.

This is an object-oriented module
which inherits from
the Data::Random::Structure manpage and extends its functionality by
providing for unicode keys and values for hashtables and
unicode content for array elements or scalars, randomly mixed with the
usual repertoire of the Data::Random::Structure manpage, which is
non-unicode strings,
numerical, boolean values and the assorted entourage to the court
of Emperor Computer, post-Turing.

For example, it produces these:

=over 4

=item * unicode scalars: e.g. `".N.B.u"',

=item * mixed arrays: e.g. `[".N.B.u", "123", "xyz"]'

=item * hashtables with some/all keys and/or values as unicode: e.g.
`{".N.B.u" =' "123", "xyz" => ".N.B.u"}>

=item * exclusive unicode arrays or hashtables: e.g. `[".N.B.u", ".'.'.c"]'

=back

This is accomplised by adding an extra
type `string-UTF8' (invisible to the user) and the
respective generator method. All these are invisible to the user
which will get the old functionality plus some (or maybe none
because this is a random process which does not eliminate non-unicode
strings, at the moment) unicode strings.

    use Data::Random::Structure::UTF8;

    my $randomiser = Data::Random::Structure::UTF8->new(
        'max_depth' => 5,
        'max_elements' => 20,
        # all the strings produced (keys, values, elements)
_# will be unicode strings
_'only-unicode' => 1,
        # all the strings produced (keys, values, elements)
_# will be a mixture of unicode and non-unicode
_# this is the default behaviour
_#'only-unicode' => 0,
        # only unicode strings will be produced for (keys, values, elements),
_# there will be no numbers, no bool, only unicode strings
_#'only-unicode' => 2,
    );...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes README.md
%perl_vendor_privlib/D*

%changelog
