%define module_version 0.140490
%define module_name Data-Remember
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Class/Load.pm) perl(Config.pm) perl(Cwd.pm) perl(DBM/Deep.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(POE.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Sub/Exporter.pm) perl(Test/More.pm) perl(YAML.pm) perl(YAML/Syck.pm) perl(base.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.140490
Release: alt1
Summary: remember complex information without giving yourself a headache
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/H/HA/HANENKAMP/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
While designing some IRC bots and such I got really tired of statements that looked like:.
  $heap->{job}{$job} = {
      source  => $source,
      dest    => $destination,
      options => $options,
  };

and later:

  if ($heap->{job}{$job}{options}{wibble} eq $something_else) {
      # do something...
  }

I could simplify things with intermediate variables, but then I inevitably end up with 4 or 5 lines of init at the start or middle of each subroutine. Yech.

So, I decided that it would be nice to simplify the above to:

  remember [ job => $job ], {
      source  => $source,
      dest    => $destination,
      options => $options,
  };

and later:

  if (recall [ job => $job, options => 'wibble' ] eq $something_else) {
      # do something...
  }

Which I consider to far more readable.

The second aspect that this deals with is long-term storage. I started using the DBM::Deep manpage to remember the important bits of state across bot restarts. This package will store your information persistently for you too if you want:

  use Data::Remember DBM => 'state.db';

By using that command, the the Data::Remember::DBM manpage "brain" is used instead of the usual the Data::Remember::Memory manpage brain, which just stores things in a Perl data structure.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/D*

%changelog
