%define module_name Data-Resolver
Epoch: 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Tar.pm) perl(Archive/Tar/Constant.pm) perl(Encode.pm) perl(JSON/PP.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(Ouch.pm) perl(Path/Tiny.pm) perl(Test/Exception.pm) perl(Test/Pod.pm) perl(experimental.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: resolve keys to data
Group: Development/Perl
License: apache
URL: https://codeberg.org/polettix/Data-Resolver

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POLETTIX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
While coding, two problems often arise:

=over

=item *

Using several modules, there can be a variety of ways on how they get
access to data. Many times they support reading from a file, but often
times they expect to receive data (e.g. the JSON::PP manpage). Other times
modules an be OK with both, and even accept *filehandles*.

=item *

Deciding on where to store data and what to use as a source can be
limiting, especially when multiple *things* might be needed. What is
best at that point? A directory? An archive? A few URLs?

=back

This module aims at providing a way forward to cope for both problems,
by providing a unified interface that can get three types of *data
types* (i.e. `data', `file', or `filehandle') while at the same time
providing a very basic interface that can be backed by several different
fetching approaches, like reading from a directory, taking items from an
archive, or download stuff on the fly from a URL.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/D*

%changelog
