%define module_name Data-ResultSet
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(ExtUtils/CBuilder.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Test/Exception.pm) perl(Test/MockObject.pm) perl(Test/More.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.002
Release: alt1
Summary: Container for aggregating and examining multiple results
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DS/DSKOLL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Data::ResultSet is a container object for aggregating and examining
multiple results.  It allows multiple result objects matching the same
method signature to be returned as a single object that can then be
queried for success or failure in a number of ways.

This is accomplished by generating wrappers to methods in the
underlying list of result objects.  For example, if you have a result
object that has an is_ok() method, you can create a Data::ResultSet
subclass to handle it with:

    package MyApp::ResultSet;
    use base qw( Data::ResultSet );
    __PACKAGE__->make_wrappers( 'is_ok' );
    1;

This will generate `all_ok', `has_ok', `get_ok', and `get_not_ok'
methods in MyApp::ResultSet that use the `is_ok' accessor on your
result object.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
