%define module_name Data-Reuse
%define _without_test 1
# TODO: fix tests
%ifarch %ix86
%define _without_test 1
%endif
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(Data/Alias.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.13
Release: alt1
Summary: share constant values with Data::Alias
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LN/LNATION/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
By default, Perl doesn't share literal ( 0, 'foo' , "bar" ) values.  That's
because once a literal value is stored in variable (a container), the contents
of that container can be changed.  Even if such a container is marked
"read-only" (e.g. with a module such as the Scalar::ReadOnly manpage), it will not
cause the values to be shared.  So each occurrence of the same literal value
has its own memory location, even if it is internally marked as read-only.

In an ideal world, perl would keep a single copy of each literal value
(container) and have all occurrences in memory point to the same container.
Once an attempt is made to change the container would perl make a copy of the
container and put the new value in there.  This principle is usually referred
to as Copy-On-Write (COW).  Unfortunately, perl doesn't have this.

Comes in the the Data::Alias manpage module which allows you to share containers
between different variables (amongst other things).  But it still does not
allow you to have literal values share the same memory locations.

Comes in this module, the the Data::Reuse manpage module, which allows you to easily
have literal and read-only values share the same memory address.  Which can
save you a lot of memory when you are working with large data structures with
similar values.  Which is especially nice in a mod_perl environment, where
memory usage of persistent processes is one of the major issues..

Of course, no memory savings will occur for literal values that only occur
once.  So it is important that you use the functionality of this module
wisely, only on values that you expect to be duplicated at least two times.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README CHANGELOG
%perl_vendor_privlib/D*

%changelog
