%define module_name Data-Sah-DefaultValue
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dmp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(IPC/System/Options.pm) perl(JSON/MaybeXS.pm) perl(Log/ger.pm) perl(Nodejs/Util.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Needs.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt1
Summary: Default-value rules for Data::Sah
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Data-Sah-DefaultValue

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module generates code to set default value using value rules.

A value rule is put in `Data::Sah::Value::$COMPILER::$TOPIC::$DESCRIPTION'
module, for example: the Data::Sah::Value::perl::Perl::this_mod manpage contains the
value "this module" (see the App::ThisDist manpage for more details on the meaning of
"this module").

Basically, a value rule will provide an expression (`expr_value') that return
some value.

The module must contain `meta' subroutine which must return a hashref that has
the following keys (`*' marks that the key is required):

=over

=item * v* => int (default: 1)

Metadata specification version. From the DefHash manpage. Currently at 4.

=item * summary => str

From the DefHash manpage.

=back

The module must also contain `default_value' subroutine which must generate the
code for default value. The subroutine must accept a hash of arguments (`*'
indicates required arguments):

=over

=back

The `value' subroutine must return a hashref with the following keys (`*'
indicates required keys):

=over

=item * expr_value => str

Expression in the target language that produces the value.

=item * modules => hash

A list of modules required by the expressions.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/D*

%changelog
