# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Table.pm) perl(Excel/Writer/XLSX.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Spreadsheet/ParseExcel.pm) perl(Spreadsheet/ParseXLSX.pm) perl(Spreadsheet/WriteExcel.pm)
# END SourceDeps(oneline)
%define module_version 0.5
%define module_name Data-Table-Excel
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.5
Release: alt1
Summary: Convert between Data::Table objects and Excel (xls/xlsx) files.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/E/EZ/EZDB/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
=over 4

To read and write Excel .xls (2003 and prior) format, we use Spreadsheet::WriteExcel and Spreadsheet::ParseExcel; to read and write Excel .xlsx (2007 format),
we use Spreadsheet::ParseXLSX and Excel::Writer::XLSX.  If this module gives incorrect results, please check if the corresponding Perl modules are updated. (We switch to Spreadsheet::ParseXLSX from Spreadsheet::XLSX from version 0.5)

=item xls2tables ($fileName, $sheetNames, $sheetIndices) 

=item xlsx2tables ($fileName, $sheetNames, $sheetIndices)

=item excelFileToTable ($fileName, $sheetNames, $sheetIndices, $excelFormat)

xls2tables is for reading Excel .xls files (binary, 2003 and prior), xlsx2table is for reading .xlsx file (2007, compressed XML format).
excelFileToTable can automatically detect Excel format if format is not specified.

$fileName is the input Excel file.
$sheetNames is a string or a reference to an array of sheet names.
$sheetIndices is a int or a reference to an array of sheet indices.
$excelFormat in excelFileToTable has to be either "2003" or "2007". Auto-detected if not specified.
If neither $sheetNames or $sheetIndices is provides, all sheets are converted into table objects, one table per sheet.
If $sheetNames is provided, only sheets found in the @$sheetNames array is converted.
If $sheetIndices is provided, only sheets match the index in the @$sheetIndices array is converted (notice the first spreadsheet has an index of 1).

The method returns an array ($tableObjects, $tableNames, $columnHeaders).
$tableObjects is a reference to an array of Data::Table objects.
$tableNames is a reference to an array of sheet names, corresponding to $tableObjects.
$columnHeaders is a reference to an array of booleans, indicating whether each table has original column header
If a table does not have a column header, columns are named Col1, Col2, etc.

  # print each of spreadsheet into an HTML table on the web
  ($tableObjects, $tableNames, $columnHeaders)=xls2tables("Tables.xls");
  foreach my $t (@$tableObjects) {
    print "<h1>", shift @$tableNames, "</h1><br>";
    print $t->html;
  }

  ($tableObjects, $tableNames, $columnHeaders)=xlsx2tables("Tables.xlsx", undef, [1]);

This will only read the first sheet. By providing sheet names or sheet indicies, you save time if you are not interested in all the sheets.

=item tables2xls ($fileName, $tables, $names, $colors, $portrait, $columnHeaders) 

=item tables2xlsx ($fileName, $tables, $names, $colors, $portrait, $columnHeaders) 

=item tables2excel ($fileName, $tables, $names, $colors, $portrait, $excelFormat, $columnHeaders)

table2xls is for writing Excel .xls files (binary, 2003 and prior), xlsx2table is for writing .xlsx file (2007, compressed XML format).
tables2excel will export to 2007 format, if $excelFormat is not specified.

$fileName is used to name the output Excel file.
$tables is a reference to an array of Data::Table objects to be write into the file, one sheet per table.
$names is a reference to an array of names used to name Spreadsheets, if not provided, it uses "Sheet1", "Sheet2", etc.
$colors is a reference to an array of reference to a color array.
Each color array has to contains three elements, defining Excel color index for odd rows, even rows and header row. 
Acceptable color index (or name) is defined by the docs\palette.html file in the CPAN Spreadsheet::WriteExcel package.

$portrait is a reference to an array of orientation flag (0 or 1), 1 is for Portrait (the default), where each row represents a table row.  In landscape (0) mode, each row represents a column.  (Similar to Data::Table::html and Data::Table::html2).

$columnHeaders is a reference to an array of boolean, indicating whether to export column headers for each table. By default, column headers are exported.

The arrays pointed by $names, $colors, $portraits and $columnHeader should be the same length as that of $tables. these customization values are applied to each table objects sequentially.
If a value is missing for a table, the method will use the setting from the previous table.

  tables2xls("TwoTables.xls", [$t_A, $t_B], ["Table_A","Table_B"], [["white","silver","gray"], undef], [1, 0], [1, 1]);

This will produce two spreadsheets named Table_A and Table_B for table $t_A and $t_B, respectively.  The first table is colored in a black-white style, the second is colored by the default style.
The first table is the default portrait oritentation, the second is in the transposed orientation.

=item is_xlsx($fileName)

Returns boolean whether the given file is 2007 format. It does not rely on file name, but reads the first two bytes of the file. .xlsx is in Zip format, therefore the first two bytes are "PK".

=item xlsx2xls($fromFileName, $toFileName)

=item xls2xlsx($fromFileName, $toFileName)

Converts an Excel file from one format to another. If $toFileName is not specified, $toFileName will be the same as $fromFileName, except with extension sets to .xlsx or .xls.

=back


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*
%perl_vendor_privlib/auto/*

%changelog
