%define module_name Data-TableReader
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(IO/Handle.pm) perl(List/Util.pm) perl(Log/Any.pm) perl(Log/Any/Adapter.pm) perl(Log/Any/Adapter/TAP.pm) perl(Module/Runtime.pm) perl(Moo.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Text/CSV.pm) perl(Try/Tiny.pm) perl(namespace/clean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.021
Release: alt1
Summary: Locate and read records from human-edited data tables (Excel, CSV)
Group: Development/Perl
License: perl
URL: https://github.com/nrdvana/perl-Data-TableReader

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NERDVANA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is designed to be a useful for anyone who needs to take "loose"
or "dirty" tabular data sources (such as Excel, CSV, TSV, or HTML) which may
have been edited by non-technical humans and extract the data into sanitized
records, while also verifying that the data file contains roughly the schema
you were expecting.  It is primarily intended for making automated imports
of data from non-automated or unstable sources, and providing human-readable
feedback about the validity of the data file.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md README
%perl_vendor_privlib/D*

%changelog
