%define module_name Data-Tersify
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(Devel/OverloadInfo.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Module/Pluggable.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(lib.pm) perl(overload.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.003
Release: alt1
Summary: generate terse equivalents of complex data structures
Group: Development/Perl
License: perl
URL: https://github.com/skington/data-tersify

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SK/SKINGTON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Complex data structures are useful; necessary, even. But they're not
*helpful*. In particular, when you're buried in the guts of some code
you don't fully understand and you have a variable you want to inspect,
and you say `x $foo' in the debugger, or `print STDERR Dumper($foo)' from
your code, or something very similar with the dumper module of your choice,
and you then get *pages upon pages of unhelpful stuff* because `$foo'
contained, *somewhere* a reference to a DateTime, DBIx::Class, Moose or other
verbose object... you didn't need that.

Data::Tersify looks at any data structure it's given, and if it finds a
blessed object that it knows about, anywhere, it replaces it in the data
structure by a terser equivalent, designed to (a) not use up all of your
scrollback, but (b) be blatantly clear that this is *not* the original object
that was in that data structure originally, but a terser equivalent.

Do not use Data::Tersify as part of any serialisation implementation! By
design, Data::Tersify is lossy and will throw away information! That's because
it supposes that that if you're using it, you want to dump information about a
complex data structure, and you don't *care* about the fine details.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README CHANGES
%perl_vendor_privlib/D*

%changelog
