# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Module/Build.pm) perl(Moo.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Data-ValidateInterdependent
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.000001
Release: alt1
Summary: safely validate interdependent parameters
Group: Development/Perl
License: perl
URL: https://github.com/latk/p5-Data-ValidateInterdependent

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AM/AMON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The problem: you need to validate some configuration.
But validation of one field depends on other fields,
or default values are taken from other parts of the config.
These dependencies can be daunting.

This module makes the dependencies between different validation steps
more explicit:
Each step declares which variables it provides,
and which variables or input parameters it consumes.
The idea of
Static Single Assignment
allows us to check basic consistency properties when the validator is assembled:

=over

=item *

The validator will provide all declared output variables.
Because there is no branching,
it is not possible to forget a variable.

=item *

All variables are declared before they are used.
It is not possible to accidentally read an unvalidated value.

=item *

Each variable is only initialized once.
It is not possible to accidentally overwrite a variable.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/D*

%changelog
