%define module_name Database-Abstraction
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Config/Auto.pm) perl(DBD/CSV.pm) perl(DBD/SQLite/Constants.pm) perl(DBD/XMLSimple.pm) perl(Data/Dumper.pm) perl(Data/Reuse.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(File/pfopen.pm) perl(FindBin.pm) perl(Gzip/Faster.pm) perl(Log/Abstraction.pm) perl(Params/Get.pm) perl(Scalar/Util.pm) perl(Test/Carp.pm) perl(Test/Compile.pm) perl(Test/DescribeMe.pm) perl(Test/Most.pm) perl(Test/Needs.pm) perl(Test/NoWarnings.pm) perl(Text/CSV/Slurp.pm) perl(Text/xSV/Slurp.pm) perl(XML/Simple.pm) perl(autodie.pm) perl(boolean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.26
Release: alt1
Summary: database abstraction layer
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NH/NHORNE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Abstract class giving read-only access to CSV, XML and SQLite databases via Perl without writing any SQL.
Look for databases in $directory in this order:
1) SQLite (file ends with .sql)
2) PSV (pipe separated file, file ends with .psv)
3) CSV (file ends with .csv or .db, can be gzipped)
4) XML (file ends with .xml)

For example, you can access the files in /var/db/foo.csv via this class:

    package MyPackageName::Database::Foo;

    use Database::Abstraction;

    our @ISA = ('Database::Abstraction');

    1;

You can then access the data using:

    my $foo = MyPackageName::Database::Foo->new(directory => '/var/db');
    print 'Customer name ', $foo->name(customer_id => 'plugh');
    my $row = $foo->fetchrow_hashref(customer_id => 'xyzzy');
    print Data::Dumper->new([$row])->Dump();

CSV files can have empty lines or comment lines starting with '#',
to make them more readable.

If the table has a column called "entry", sorts are based on that
To turn that off, pass 'no_entry' to the constructor, for legacy
reasons it's enabled by default

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes
%perl_vendor_privlib/D*

%changelog
