%define module_name Database-ManagedHandle
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Const/Fast.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Database/Temp.pm) perl(English.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FindBin.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Log/Any.pm) perl(Module/Load.pm) perl(Moo.pm) perl(MooX/Singleton.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Test/Database/Temp.pm) perl(Test/More.pm) perl(Test2/Require/Module.pm) perl(Test2/V0.pm) perl(lib.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Manage database handles safely for long running processes
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Database-ManagedHandle

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MI/MIKKOI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Database::ManagedHandle is built for those long running web services or scripts
which can lose a database connection due to network issues, database being updated,
database itself closing unused connections after an idle period
or any other reason.

Database::ManagedHandle uses the Moo manpage and specifically the the MooX::Singleton manpage role to become
a Singleton.
This ensures that there is always only one instance of the class
in the entire running program. This in turn means that the program needs
only one database handle and it is accessible from any part of the code.

Database::ManagedHandle opens and reopens database handles when required.
It can house several handles. If there is more than one, then one handle
needs to be defined as the default.

When the program first requests a database handle,
either a named handle or the default,
Database::ManagedHandle opens the database connection and
passes the opened handle to the program.
After using the handle, the program does not need to worry about it.
It can safely let the variable fall out of scope.

During subsequent calls for the handle, Database::ManagedHandle
first ensures that the connection is still alive.
If not, it will establish the handle again.

Do not keep a database handle around.
Only use the same handle for one operation, then purposefully undef it or let it
drop out of scope.
When you need it again, get it from Database::ManagedHandle.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/D*

%changelog
