%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Readonly.pm) perl(Readonly/XS.pm) perl(Test/Manifest.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(version.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_version 0.2.1
%define module_name Date-Components
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.1
Release: alt1
Summary: Parses, processes and formats ONLY dates and date components
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DM/DMAC/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Date::Components parses dates into components on the front end, formats them on
the back end and enables many operations on whole dates and date components in
between.

This unique module was created to combine a parser, formatter, component
operators and time independence into a single unit.  Independence of time also
enables the widest date range possible (limited by integer size).  Applications
include portfolio management where only dates are relevant.  With the variety
of supported date formats, it can be used as an in-line date re-formatter.
Subroutines providing operations specific to the standard 400 year cycle are
included also.

The module is not object oriented.  Rather, it supplies a variety of
useful functions to analyze, process and format complete dates and the four
date components of *month*, *day-of-month*, *year* and *day-of-week*.
ALL representations of time and related parameters are ignored, including
hours, minutes, seconds, time zones, daylight savings time, etc.

Leap year standard is used.  According to the Royal Greenwich Observatory, the
calendar year is 365 days long, unless the year is exactly divisible by four,
then an extra day is added to February so the year is 366 days long. If the
year is the last year of a century, e.g., 2000, 2100, 2200, 2300, 2400, then it
is only a leap year if it is exactly divisible by 400. So, 2100 won't be a leap
year but 2000 is. The next century year, exactly divisible by 400, won't occur
until 2400--400 years away.

Subroutines `is_valid_date', `format_date' and `get_numeric_day_of_week'
are overloaded to accept either a list of date components or a single SCALAR
date string to enable more flexible usage.

Date strings returned by subroutines are always in default format.



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
