%define module_name Date-Holidays-TW
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Yath.pm) perl(DateTime.pm) perl(DateTime/Calendar/Chinese.pm) perl(Module/Build/Tiny.pm) perl(Test2/V0.pm) perl(Text/CSV.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.8.0
Release: alt1
Summary: Determine whether it is Taiwan Holidays or not.
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GU/GUGOD/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This module provides functions to look into Taiwan holiday calendars
for known holidays. It could be used by itself, or under via
the Date::Holidays manpage module.

Caveat: Due to the rule of weekend-compensation and the fact that the
majority of holidays are defined by Chinese calendar (Lunar), it
requires some non-trivial amount of computation to correctly determine
whether the given date is an holiday or not -- which is not
implemented at this version.

The current implementation includes all known holidays of year 2019
and 2020 as a lookup table and should therefore correctly determine
holidays in those 2 years. It should also determine most of the future
updates correct by some basic compuation, except for the ones
generated by the weekend-compensation rule.

Conventionally the holiday calendar for the next year is announcend at
the end of June and we could start to mix the new information into the
lookup table in this module.

Generally speaking, queries for far future should be avoided.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE CONTRIBUTING.md
%perl_vendor_privlib/D*

%changelog
