%define module_name Date-Holidays-UA
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime.pm) perl(DateTime/Event/Easter.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Holidays module for Ukraine
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DB/DBOYS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
# procedural approach

    use Date::Holidays::UA qw(:all);

    my ($year, $month, $day) = (localtime)[5, 4, 3];
    $year  += 1900;
    $month += 1;

    print 'Holiday!' if is_holiday($year, $month, $day);

    my $calendar = holidays($year, {language => 'en'});
    print $calendar->{'0824'};


    # object-oriented approach

    use DateTime;
    use Date::Holidays::UA;

    my $ua = Date::Holidays::UA->new({ language => 'en' });
    print 'Holiday!' if $ua->is_holiday_dt(DateTime->today);

    my $calendar = $ua->holidays(DateTime->today->year);
    print join("\n", value(%%$calendar)); # list of holiday names for Ukraine

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes ignore.txt LICENSE README.md README
%perl_vendor_privlib/D*

%changelog
