# BEGIN SourceDeps(oneline):
BuildRequires: perl(B.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_name Date-Indiction
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Compute a year's indiction as used in old Russian chronicles
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RP/RPAVLOV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Indiction (called *indict* in Russian chronicles) is the number of
the year in a 15-year cycle, starting from September 1, 312 AD. It can
be calculated for either Byzantine year (Anno Mundi, AM, old Russian
style with the epoch on March 1, 5508 BCE) or Christian year (Anno
Domini, AD). The formulae are, respectively,

    I = AM %% 15

    I = (AD + 3) %% 15

adding 1 for dates after the 1st of September since indictions change
on this date. (Other counting bases did exist in Western Europe,
however not covered by this module.) See Klimishin I.A. "Calendar and
Chronology". Moscow, Nauka, 1985, pp. 82-85.

The module uses byzantine aera by default. Christian aera can be
requested explicitly on module load or set using `set_aera' function.

Setting 'christian' is equal to 'AD' and 'byzantine' to 'AM'. Keywords
'christian' and 'byzantine' are case-insensitive.

Month from January to December are numbered from 1 to 12 respectively
for both aerae, although in the Byzantine aera March is the month
number 1, etc. This can be changed in future in favour of more
human-friendly strings like "Jan" or "January".

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
