%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(POSIX.pm) perl(Switch.pm) perl(Test/Simple.pm) perl(Tie/IxHash.pm)
# END SourceDeps(oneline)
%define module_version 0.11
%define module_name Date-Transform
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: Efficiently transform dates.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CT/CTBROWN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Sullivan Beck's Date::Manip is an excellent module for performing 
operations involving dates.  However, because of its extraordinary flexibility, 
it is slow when much date parsing is needed.  

I found that more than 95%% of my operations using dates required repeated 
operations of going from YYYY-mm-dd to mm/dd/YYYY.  This occurs often
when changing an array or column of dates from one format to another.  While 
Date::Manip `UnixDate' function can do this, its flexibility nature causes it to be slower than
often needed.  

When the input format is specified beforehand, parsing of the input date becomes much
easier and the speed of the transformation can be greatly enhanced.  Date::Transform 
provides this by writing a custom algorithm maximized to the specific operation.  
While a considerable initialization is required to creation the transformation code,
the resultant transformation are typically 300-500%% faster than `UnixDate'.  


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README docs
%perl_vendor_privlib/D*
%perl_vendor_privlib/auto/*
%changelog
