# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime.pm) perl(DateTime/Format/Unicode.pm) perl(DateTime/Locale/FromCLDR.pm) perl(ExtUtils/MakeMaker.pm) perl(Locale/Intl.pm) perl(Locale/Unicode/Data.pm) perl(Module/Signature.pm) perl(Scalar/Util.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Want.pm) perl(lib.pm) perl(open.pm) perl(parent.pm) perl(strict.pm) perl(utf8.pm) perl(vars.pm) perl(warnings.pm) perl(warnings/register.pm)
# END SourceDeps(oneline)
%define module_name DateTime-Format-Intl
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.8
Release: alt1
Summary: A Web Intl.DateTimeFormat Class Implementation
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JD/JDEGUEST/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This module provides the equivalent of the JavaScript implementation of Intl.DateTimeFormat

It relies on the DateTime::Format::Unicode manpage, the DateTime::Locale::FromCLDR manpage, the Locale::Unicode::Data manpage, which provides access to all the Unicode CLDR (Common Locale Data Repository), and the Locale::Intl manpage to achieve similar results. It requires perl v5.10.1 minimum to run.

It is very elaborate and the algorithm provides the same result you would get with a web browser. The algorithm itself is quite complex and took me several months to implement, given all the dependencies with the modules aforementioned it relies on, that I also had to build to make the whole thing work.

I hope they will benefit you as they benefit me.

Because, just like its JavaScript equivalent, `DateTime::Format::Intl' does quite a bit of look-ups and sensible guessing upon object instantiation, you want to create an object for a specific format, cache it and re-use it rather than creating a new one for each date formatting.

`DateTime::Format::Intl' uses a set of culturally sensible default values derived directly from the web browsers own default. Upon object instantiation, it uses a culturally sensitive scoring to find the best matching format pattern available in the Unicode CLDR (Common Locale Data Repository) data for the options provided. It appends any missing components, if any. Finally, it adjusts the best pattern retained to match perfectly the options of the user.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README CHANGES CONTRIBUTING.md TODO LICENSE README.md
%perl_vendor_privlib/D*

%changelog
