# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(DateTime.pm) perl(DateTime/Locale/FromCLDR.pm) perl(DateTime/TimeZone.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find.pm) perl(Locale/Unicode.pm) perl(Module/Signature.pm) perl(POSIX.pm) perl(Scalar/Util.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Want.pm) perl(lib.pm) perl(parent.pm) perl(strict.pm) perl(utf8.pm) perl(vars.pm) perl(version.pm) perl(warnings.pm) perl(warnings/register.pm)
# END SourceDeps(oneline)
%define module_name DateTime-Format-Unicode
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.0
Release: alt1
Summary: Unicode CLDR Formatter for DateTime
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JD/JDEGUEST/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This is a Unicode CLDR (Common Locale Data Repository) formatter for the DateTime manpage

It differs from the default formatter used in the DateTime manpage with its method format_cldr in several aspects:

=over 4

=item 1. It uses the DateTime::Locale::FromCLDR manpage

A much more comprehensive and accurate API to dynamically access the Unicode `CLDR' data whereas the module the DateTime manpage relies on, the DateTime::Locale manpage, which uses static data from over 1,000 pre-generated modules.

=item 2. It allows for any `locale'

Since, it uses dynamic data, you can use any `locale', from the simple `en' to more complex `es-001-valencia', or even `ja-t-de-t0-und-x0-medical'

=item 3. It allows formatting of datetime intervals

Datetime intervals are very important, and unfortunately unsupported by the DateTime manpage as of July 2024.

=item 4. It supports more pattern tokens

the DateTime manpage format_cldr does not support all of the CLDR pattern tokens, but the DateTime::Format::Unicode manpage does.

Known pattern tokens unsupported by the DateTime manpage are:

=over 8

=item * `b'

Period of the day, such as `am', `pm', `noon', `midnight'

See the calendar_term entry in the Locale::Unicode::Data manpage and its corollary the day_period entry in the Locale::Unicode::Data manpage

=item * `B'

Flexible day periods, such as `at night'

See the calendar_term entry in the Locale::Unicode::Data manpage and its corollary the day_period entry in the Locale::Unicode::Data manpage

=item * `O'

Zone, such as `O' to get the short localized GMT format `GMT-8', or `OOOO' to get the long localized GMT format `GMT-08:00'

=item * `r'

Related Gregorian year (numeric).

The documentation states that "For the Gregorian calendar, the .e'r.e' year is the same as the .e'u.e' year."

=item * `U'

Cyclic year name. However, since this is for non gregorian calendars, like Chinese or Hindu calendars, and since the DateTime manpage only supports gregorian calendar, we do not support it either.

=item * `x'

Timezone...

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE CHANGES README.md TODO CONTRIBUTING.md README
%perl_vendor_privlib/D*

%changelog
