Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-DateTime-Precise
Version:        1.05
Release:        alt2_53

Summary:        Perform common time and date operations with additional GPS operations

License:        LicenseRef-Fedora-Public-Domain
URL:            https://metacpan.org/release/DateTime-Precise
Source0:        https://cpan.metacpan.org/authors/id/B/BZ/BZAJAC/DateTime-Precise-%{version}.tar.gz

BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(integer.pm)
BuildRequires:  perl(overload.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)

%{echo 
%filter_from_provides /perl.bigfloat.pm./d
%filter_from_provides /perl.bigint.pm./d
%filter_from_requires /perl.DateTime.Math\/bigfloat.pl.pm./d
%filter_from_requires /perl.DateTime.Math\/bigint.pl.pm./d

}


Source44: import.info

%description
The purpose of this library was to replace our dependence on Unix epoch time,
which, being limited to a range of about 1970 to 2030, is inadequate for our
purposes (we have data as old as 1870). This date library effectively handles
dates from A.D. 1000 to infinity, and would probably work all the way back to 0
(ignoring, of course, the switch-over to the Gregorian calendar). The useful
features of Unix epoch time (ease of date difference calculation and date
comparison, strict ordering) are preserved, and elements such as
human-legibility are added. The library handles fractional seconds and some
date/time manipulations used for the Global Positioning Satellite system.


%prep
%setup -q -n DateTime-Precise-%{version}


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}


%install
%{makeinstall_std}
# %{_fixperms} $RPM_BUILD_ROOT


%check
make test


%files
%doc CHANGES README
%{perl_vendor_privlib}/*


%changelog
