# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(Filter/Util/Call.pm) perl(Test/More.pm) perl(autodie.pm)
# END SourceDeps(oneline)
%define module_name Debug-Comments
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000
Release: alt1
Summary: Source filter which turns comments into log messages
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TF/TFBW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is a Perl source filter which turns certain comments into
debug output.  It's a good alternative to peppering your code with `warn "..." if DEBUG;' statements: the comments are simply comments
with no overhead in the absence of the filter, but still informative
in their own right.

The output is primarily intended to provide a visual trace of where
your code is going, so it includes the filename and line number where
the debug comment is located.  This part is colour-coded on TTY output
by default to make it visually distinct.  Aside from that, the comment
is interpreted as though it appeared in double-quotes at that point in
your code, allowing display of most simple values.

This filter tries to be super-simple rather than super-smart, so some
caution is required to ensure you don't translate something other than
a comment into a debug output statement.  This module takes the
pragmatic approach that a sufficiently distinctive prefix is good
enough for the job.  You can choose your own if you aren't happy with
the default.  Mixed code-and-comment lines are never altered.

Perl source filters in general are fraught with peril and should be
used very sparingly.  That said, this approach has significant
advantages over any other approach.  First, the source is valid and
reasonable when the filter is excluded, so using it does not create a
dependency on it.  The filter can be excluded very easily via "use
if", and should be excluded by default.  Second, there is zero
overhead for the debug code when excluded: they are simple comments.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes README.md
%perl_vendor_privlib/D*

%changelog
