%define module_name Debug-Print
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Term/ANSIColor.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Tie/STDOUT.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Make debugging with print() more awesome
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Debug-Print

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
One of the simplest (and oldest) debugging technique is adding `print'
statements to your code. Although not very flexible, it forever remains as one
of programmers' favorites.

This module allows you to:

=over

=item * Add more information to your print()

For example: filename and line, timestamp.

=item * Add color

=item * Filtering

For example: don't output if string matches qr/\ADEBUG:/.

=back

so debugging using `print()' can be more useful. (Although I still recommend
you to use a proper logging framework.)

Caveat: This module is still in its early development. API might change. Current
limitations:

=over

=item * Only print() to STDOUT is captured

Output to STDERR or other filehandles are currently not captured.

`printf()' is currently not captured.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/D*

%changelog
