%define module_version 0.065
%define module_name Dependencies-Searcher
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Ack.pm) perl(Data/Printer.pm) perl(ExtUtils/Installed.pm) perl(ExtUtils/MakeMaker.pm) perl(File/HomeDir.pm) perl(File/Spec/Functions.pm) perl(File/Stamped.pm) perl(IO/File.pm) perl(IPC/Cmd.pm) perl(IPC/Run.pm) perl(Log/Minimal.pm) perl(Module/CoreList.pm) perl(Module/Version.pm) perl(Moose.pm) perl(Path/Class.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Version/Compare.pm) perl(autodie.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.065
Release: alt1
Summary: Search recursively dependencies used in a module's 
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SM/SMONF/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Maybe you don't want to have to list all the dependencies of your application by hand,.or maybe you forgot to do it for a long time ago. During this time, you've add lots of
CPAN modules. Carton is here to help you manage dependencies between your development 
environment and production, but how to keep track of the list of modules you will give
to Carton?

You will need a tool that will check for any 'requires' or 'use' in your module package, 
and report it into a file that could be used as a Carton cpanfile. Any duplicated entry 
will be removed and versions are available.

This project has begun because it happens to me, and I don't want to search for modules
to install, I just want to run a simple script that update the list in a simple way.

    use Dependencies::Searcher;

    my $searcher = Dependencies::Searcher->new();
    my @elements = $searcher->get_files();
    my $path = $searcher->build_full_path(@elements);
    my @uses = $searcher->get_modules($path, "use");		
    my @uniq_modules = $searcher->uniq(@uses);

    $searcher->dissociate(@uniq_modules);

    $searcher->generate_report($searcher->non_core_modules);


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md
%perl_vendor_privlib/D*

%changelog
