%define module_name Devel-Constants
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(constant.pm) perl(lib.pm) perl(strict.pm) perl(subs.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.04
Release: alt2
Summary: translates constants back to named symbols
Group: Development/Perl
License: perl
URL: https://github.com/neilb/Devel-Constants

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NEILB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Declaring constants is very convenient for writing programs, but as Perl often
inlines them, retrieving their symbolic names can be tricky.  This worse with
lowlevel modules that use constants for bit-twiddling.

Devel::Constants makes this much more manageable.

It silently wraps around the the constant manpage module, intercepting all constant
declarations.  It builds a hash, associating the values to their names, from
which you can retrieve their names as necessary.

Note that you must use Devel::Constants *before* `constant', or the magic
will not work and you will be very disappointed.  This is very important, and
if you ignore this warning, the authors will feel free to laugh at you (at
least a little.

By default, Devel::Constants only intercept constant declarations within the
same package that used the module.  Also by default, it stores the constants
for a package within a private (read, otherwise inaccessible) variable.  You
can override both of these.

Passing the `package' flag to Devel::Constants with a valid package name will
make the module intercept all constants subsequently declared within that
package.  For example, in the main package you might say:

  use Devel::Constants package => NetPacket::TCP;
  use NetPacket::TCP;

All of the TCP flags declared within the NetPacket::TCP manpage are now available.

It is also possible to pass in a hash reference in which to store the constant
values and names:

  my %%constant_map;
  use Devel::Constants \%%constant_map;
  
  use constant NAME_=> 1;
  use constant RANK_=> 2;
  use constant SERIAL_=> 4;
  
  print join(' ', values %%constant_map), "\n";

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/D*

%changelog
