%define module_name Devel-DumpTrace
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(Hash/SafeKeys.pm) perl(PPI.pm) perl(PadWalker.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(threads.pm) perl(threads/shared.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.29
Release: alt1
Summary: Evaluate and print out each line before it is executed.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MO/MOB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Similar to Devel::Trace, this module will cause a message
to be printed to standard error for each line of source code that is
executed. In addition, this module will attempt to identify variable names
in the source code and substitute the values of those variables. In this
way you can say the path of execution through your program as well
as see the value of your variables at each step of the program.

For example, if your program looks like this:

    #!/usr/bin/perl
    # a demonstration of Devel::DumpTrace
    $a = 1;
    $b = 3;
    $c = 2 * $a + 7 * $b;
    @d = ($a, $b, $c + $b);

then the `DumpTrace' output will look like:

    $ perl -d:DumpTrace demo.pl
    >>>>> demo.pl:3:        $a:1 = 1;
    >>>>> demo.pl:4:        $b:3 = 3;
    >>>>> demo.pl:5:        $c:23 = 2 * $a:1 + 7 * $b:3;
    >>>>> demo.pl:6:        @d:(1,3,26) = ($a:1, $b:3, $c:23 + $b:3);

There are also more *verbose* modes which will produce even more
detailed output:

    $ perl -d:DumpTrace=verbose demo.pl
    >>  demo.pl:3:
    >>>              $a = 1;
    >>>>>            1 = 1;
    -------------------------------------------
    >>  demo.pl:4:
    >>>              $b = 3;
    >>>>>            3 = 3;
    -------------------------------------------
    >>  demo.pl:5:
    >>>              $c = 2 * $a + 7 * $b;
    >>>>             $c = 2 * 1 + 7 * 3;
    >>>>>            23 = 2 * 1 + 7 * 3;
    -------------------------------------------
    >>  demo.pl:6:
    >>>              @d = ($a, $b, $c + $b);
    >>>>             @d = (1, 3, 23 + 3);
    >>>>>            (1,3,26) = (1, 3, 23 + 3);
    -------------------------------------------

See `$Devel::DumpTrace::TRACE' under the the section on "VARIABLES" section
for more details about the different levels of verbosity.

This distribution comes with both a basic parser and a
PPI-based parser (which relies on the PPI manpage
to understand your source code). If the PPI
module is installed on your system, then this module will automatically
use the PPI-based parser to analyze the traced code. You can
force this module to use the basic parser by running with the
`-d:DumpTrace::noPPI' argument or by setting the `DUMPTRACE_NOPPI'
environment variable:

    # use PPI if available, otherwise use basic parser
    $ perl -d:DumpTrace program.pl

    # use PPI, fail if it is not available
    $ perl -d:DumpTrace::PPI program.pl

    # always uses basic parser
    $ perl -d:DumpTrace::noPPI program.pl
    $ DUMPTRACE_NOPPI=1 perl -d:DumpTrace program.pl

See the the section on "BUGS AND LIMITATIONS" section for important, er, limitations
of this module, especially for the basic parser.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install
rm -f %buildroot%perl_vendor_privlib/binary_search.pl
rm -f %buildroot%perl_vendor_privlib/demo.pl
rm -f %buildroot%perl_vendor_privlib/littledemo.pl
rm -f %buildroot%perl_vendor_privlib/multiline.pl
rm -f %buildroot%perl_vendor_privlib/multilinedemo.pl
rm -f %buildroot%perl_vendor_privlib/thread-demo.pl
rm -f %buildroot%perl_vendor_privlib/thread-demo2.pl

%files
%doc README Changes
%perl_vendor_privlib/T*
%perl_vendor_privlib/D*

%changelog
