Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		perl-Devel-EnforceEncapsulation
Version:	0.51
Release:	alt2_33
Summary:	Find access violations to blessed objects
License:	GPL-1.0-or-later OR Artistic-1.0-Perl
URL:		https://metacpan.org/release/Devel-EnforceEncapsulation
Source0:	https://cpan.metacpan.org/modules/by-module/Devel/Devel-EnforceEncapsulation-%{version}.tar.gz
BuildArch:	noarch
# Module Build
BuildRequires:	coreutils
BuildRequires:	findutils
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
# Module Runtime
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(English.pm)
BuildRequires:	perl(overload.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(warnings.pm)
# Test Suite
BuildRequires:	perl(base.pm)
BuildRequires:	perl(Test/More.pm)
# Optional Tests
BuildRequires:	perl(Pod/Coverage.pm)
BuildRequires:	perl(Test/Pod.pm)
BuildRequires:	perl(Test/Pod/Coverage.pm)
Source44: import.info
# Dependencies
# (none)

%description
Encapsulation is the practice of creating subroutines to access the properties
of a class instead of accessing those properties directly. The advantage of
good encapsulation is that the author is permitted to change the internal
implementation of a class without breaking its usage.

Object-oriented programming in Perl is most commonly implemented via blessed
hashes. This practice makes it easy for users of a class to violate
encapsulation by simply accessing the hash values directly. Although less
common, the same applies to classes implemented via blessed arrays, scalars,
filehandles, etc.

This module is a hack to block those direct accesses. If you try to access a
hash value of an object from its own class, or a superclass or subclass, all
goes well. If you try to access a hash value from any other package, an
exception is thrown. The same applies to the scalar value of a blessed scalar,
entry in a blessed array, etc.

To be clear: this class is NOT intended for strict enforcement of
encapsulation. If you want bullet-proof encapsulation, use inside-out objects
or the like. Instead, this module is intended to be a development or debugging
aid in catching places where direct access is used against classes implemented
as blessed hashes.

To repeat: the encapsulation enforced here is a hack and is easily
circumvented. Please use this module for good (finding bugs), not evil (making
life harder for downstream developers).

%prep
%setup -q -n Devel-EnforceEncapsulation-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} -c %{buildroot}

%check
make test AUTHOR_TEST=1 AUTHOR_TEST_CDOLAN=1

%files
%doc --no-dereference LICENSE
%doc CHANGES README
%{perl_vendor_privlib}/Devel/

%changelog
