# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Devel-GDB-Breakpoint
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt7
Summary: Create easily identifiable gdb breakpoints in Perl code.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/W/WO/WOLFSAGE/%module_name-%module_version.tar.gz

%description
This module allows you to inject breakpoints into your Perl code that you can .easily identify with gdb.

It exports the `breakpoint' sub at runtime which can be called from any Perl 
code with an integer value as its argument. When the Perl codepoint is reached, 
the module calls a C function called `bp' with the argument you gave as its 
only parameter, which is named `val'.

IE, in Perl:

  breakpoint 3;

Equates to:

  void bp(int val) {};

  bp(3);

Which allows you in gdb to set breakpoints like so:

  (gdb) b bp if val == 3
  ...


%prep
%setup -n %module_name

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/D*
%perl_vendor_autolib/*

%changelog
