# BEGIN SourceDeps(oneline):
BuildRequires: perl(Devel/GDB/Breakpoint.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Parse/Keyword.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Devel-GDB-Parser-Breakpoint
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Create easily identifiable gdb breakpoints in Perl parser code.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WO/WOLFSAGE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module allows you to inject breakpoints into the parsing of your Perl
code by the perl binary that you can easily identify with gdb.

It exports the `parser_breakpoint' sub at runtime which can be called from any 
Perl code with an integer value as its argument. When the perl lexer/parser 
reaches the line, the module calls a C function called `bp' with the argument 
you gave as its only parameter, which is named `val'.

IE, in Perl:

  parser_breakpoint 3;

Equates to:

  void bp(int val) {};

  bp(3);

Which allows you in gdb to set breakpoints like so:

  (gdb) b bp if val == 3
  ...

Note that parser_breakpoint always returns the value 1. It can be used
in complex statements/expressions to see what's going on:

  if ($x && $y && parser_breakpoint 2 && $z) { ... }

And since it happens at lexer/parser time, it will still execute here:

  if (0 && parser_breakpoint 3) { ... }
%prep
%setup -q -n %{module_name}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
