%define module_name Devel-Git-MultiBisect
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/git perl(Capture/Tiny.pm) perl(Carp.pm) perl(Cwd.pm) perl(Data/Dump.pm) perl(Data/Dumper.pm) perl(Devel/CheckBin.pm) perl(Digest/MD5.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Copy.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(Getopt/Long.pm) perl(List/Util.pm) perl(Test/Simple.pm) perl(Tie/File.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.21
Release: alt1
Summary: Study test output over a range of git commits
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JK/JKEENAN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Given a Perl library or application kept in git for version control, it is
often useful to be able to compare the output collected from running one or
several test files over a range of git commits.  If that range is sufficiently
large, a test may fail in more than one way over that range.

If that is the case, then simply asking, *"When did this file start to
fail?"* is insufficient.  We may want to (a) capture the test output for each
commit; or, (b) capture the test output only at those commits where the output
changed.  The output of a run of a test file may change for a variety of
reasons:  test failures, segfaults, changes in the number or content of tests,
etc.)

Devel::Git::MultiBisect provides methods to achieve that objective.  Its
child classes, Devel::Git::MultiBisect::AllCommits and
Devel::Git::MultiBisect::Transitions, provide different flavors of that
functionality for objectives (a) and (b), respectively.  Please refer to their
documentation for further discussion.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes CONTRIBUTING.md README LICENSE examples
%perl_vendor_privlib/D*

%changelog
