# BEGIN SourceDeps(oneline):
BuildRequires: perl(Devel/GDB.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/File.pm) perl(Tree/Interval.pm) perl(threads.pm)
# END SourceDeps(oneline)
%define module_version 0.3.4
%define module_name Devel-Plumber
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.3.4
Release: alt5
Summary: memory leak finder for C programs
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GN/GNB/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Devel::Plumber is a memory leak finder for C programs, implemented in
Perl.  It uses GDB to walk internal glibc heap structures, so it can
work on either a live process or a core file.

Devel::Plumber treats the C heap of the program under test as a
collection of non-overlapping blocks, and classifies them into
one of four states.

=over

=item Free

The block is not allocated.

=item Leaked

The block is allocated but there are no pointers to any address in it,
so the program cannot reach it.

=item Maybe Leaked

The block is allocated and there are pointers to addresses within it,
but no pointers to the start of it.  The program might be able to reach
it in some unobvious way via those pointers (e.g. using pointer
arithmetic), or the pointers may be dangling pointers to earlier
generations of blocks.  Devel::Plumber cannot tell the difference
between these possibilities.

=item Reached

The block is allocated and there are pointers to the start of the block.

=back

Devel::Plumber proceeds in two main phases.  In the first phase, the
glibc internal heap structures are walked to discover all the blocks.
Unallocated blocks are set to Free state at this time and allocated
blocks are initially set to Leaked state.  In the second phase,
reachable blocks are marked.  All the *.data* and *.bss* sections in
the program (and all loaded shared libraries) are scanned for pointers.
If a pointer points to the start of a block, the block is set to Reached
state; if it points into a Leaked block, the block is set to Maybe
Leaked state.  In either case, the block's contents are also scanned for
pointers.  After the second phase is complete, any blocks still in
Leaked state are definitely leaked.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -n %{module_name}-%{module_version}
rm test.pl

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%perl_vendor_privlib/D*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
