%define module_name Devel-Trepan-Deparse
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Array/Columnize.pm) perl(B.pm) perl(B/DeparseTree.pm) perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/Printer.pm) perl(Devel/Callsite.pm) perl(Devel/Trepan.pm) perl(English.pm) perl(Exporter.pm) perl(File/Spec.pm) perl(Module/Build.pm) perl(Scalar/Util.pm) perl(Test/Simple.pm) perl(rlib.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.1.0
Release: alt1
Summary: Adds deparse support via B::DeparseTree to Devel::Trepan
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RO/ROCKY/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Perl reports location only at the granularity of a line number. Sometime you would like better or more precise information. For example suppose I am stopped on this line taken from *File::Basename::fileparse*:

     if (grep { $type eq $_ } qw(MSDOS DOS MSWin32 Epoc)) {  # ...

In a debugger, there happen to be to distinct locations in the code that you might be stopped in.
The first place is before the grep starts at all. Here, deparse will show:

      grep { $type eq $_; } 'MSDOS', 'DOS', 'MSWin32', 'Epoc'

But also you might be stopped inside grep. Here deparse will show:

    # code to be run next...
    $type
    # contained in...
    $type eq $_

Knowing which of these two locations can be helpful. For example if you are stopped in the latter location, you can evaluate `$_` to see where in the loop you are at.

See Exact Perl location with B::Deparse (and Devel::Callsite).
%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc gpl-2.0.txt ChangeLog README.md Artistic NEWS example
%perl_vendor_privlib/D*

%changelog
