%define module_name Device-Firmata
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Device/SerialPort.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Select.pm) perl(IO/Socket/INET.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.69
Release: alt1
Summary: Perl interface to Firmata for the arduino platform.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JN/JNSBYR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use strict;
use warnings;
use Device::Firmata::Constants qw/ :all /;
use Device::Firmata;
$|++;
use Time::HiRes 'sleep';

my $led_pin = 13;

my $device = Device::Firmata->open('/dev/ttyUSB0') or die "Could not connect to Firmata Server";
$device->pin_mode($led_pin=>PIN_OUTPUT);
my $iteration = 0;
while (1) {
    my $strobe_state = $iteration++%%2;
    $device->digital_write($led_pin=>$strobe_state);
    sleep 0.5;
}
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE CONTRIBUTING Changes README examples
%perl_vendor_privlib/D*

%changelog
