# BEGIN SourceDeps(oneline):
BuildRequires: perl(Device/SMBus.pm) perl(ExtUtils/MakeMaker.pm) perl(Moose.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.1
%define module_name Device-PiGlow
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1
Release: alt1
Summary: Interface for the PiGlow LED board for the Raspberry PI
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JS/JSTOWE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The PiGlow from Pimoroni (http://shop.pimoroni.com/products/piglow) is 
a small board that plugs in to the Raspberry PI's GPIO header 
with 18 LEDs on that can be addressed individually via i2c.

This module uses the Device::SMBus manpage to abstract the interface to the device
so that it can be controlled from a Perl programme.

It is assumed that you have installed the OS packages required to make
i2c work and have configured and tested the i2c appropriately.  The only
difference that seems to affect the PiGlow device is that it only seems
to be reported by `i2cdetect' if you use the "quick write" probe flag:

   sudo i2cdetect -y -q 1

(assuming you have a Rev B. Pi - if not you should supply 0 instead of 1.) 
I have no way of knowing the compatibility of the "quick write" with any
other devices you may have plugged in to the Pi, so I wouldn't recommend
doing this with any other devices unless you know that they won't be adversely
affected by "quick write".  The PiGlow has a fixed address anyway so the
information isn't that useful.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE examples
%perl_vendor_privlib/D*

%changelog
