%define module_name Device-Power-Synaccess-NP05B
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Net/Telnet.pm) perl(Test/Differences.pm) perl(Test/Most.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: Manage and monitor the Synaccess NP-05B networked power strip
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TT/TTKCIAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
my $np = Device::Power::Synaccess::NP05B->new(addr => '10.0.0.1');

    # must initiate a connection and log in before issuing commands:
    ($ok, $err) = $np->connect;
    ($ok, $err) = $np->login;

    # are we still connected?
    $np->is_connected or die "whoops";

    # get the status of the connection:
    say $np->cond;

    # get the on/off status of the power outlets:
    ($ok, $hashref) = $np->power_status;

    # turn on outlet 2:
    ($ok, $err) = $np->power_set(2, 1)

    # get the full system status, including network attributes:
    ($ok, $hashref) = $np->status;

    # must log out cleanly or device can get confused:
    ($ok, $err) = $np->logout;

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/D*

%changelog
