%define module_name Device-Yeelight
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(IO.pm) perl(IO/Socket/Multicast.pm) perl(JSON.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.14
Release: alt1
Summary: Controller for Yeelight smart devices
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JB/JBAIER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This Perl module implements local device discovery via Yeeling specific SSDP
protocol and sending commands via control protocol in the JSON format.

Device::Yeelight module provides base class for detecting Yeelight devices.

    use Device::Yeelight;

    my $yeelight = Device::Yeelight->new();
    my @devices = @{$yeelight->search()};
    foreach my $device (@devices) {
        my %%props = %%{$device->get_prop(qw/power/)};
        say "The light is $props{power}";
        $device->set_power('on', 'smooth', 1000);
    }
    ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/D*

%changelog
