Epoch: 1
%define module_name Digest-HighwayHash
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Math/Int64.pm) perl(Test/Exception.pm) perl(XSLoader.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt5
Summary: XS fast strong keyed hash function
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGV/%{module_name}-%{version}.tar.gz

%description
HighwayHash is a fast and strong keyed hash function, documented at
https://github.com/google/highwayhash.

Three functions are exported by this module, all by default:

=over

=item highway_hash64 *\@key*, *$input*

Compute the 64-bit HighwayHash of *$input*, using *\@key* as a key.
The key must be a 4-element arrayref, with each element either a
number or (on Perls without 64-bit numbers) a the Math::Int64 manpage object. The result is a single number or (on Perls without 64-bit numbers) a the Math::Int64 manpage object.

=item highway_hash128 *\@key*, *$input*

Compute the 128-bit HighwayHash of *$input*, using *\@key* as a key.
The key must be a 4-element arrayref, with each element either a
number or (on Perls without 64-bit numbers) a the Math::Int64 manpage object. The result is an array of exactly two numbers or (on Perls without 64-bit numbers) the Math::Int64 manpage objects.

=item highway_hash256 *\@key*, *$input*

Compute the 256-bit HighwayHash of *$input*, using *\@key* as a key.
The key must be a 4-element arrayref, with each element either a
number or (on Perls without 64-bit numbers) a the Math::Int64 manpage object. The result is an array of exactly four numbers or (on Perls without 64-bit numbers) the Math::Int64 manpage objects.


=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/D*
%perl_vendor_autolib/*

%changelog
