# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Digest.pm) perl(Digest/SHA.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(FindBin.pm) perl(MIME/Base64.pm) perl(Scalar/Util.pm) perl(Test/MinimumVersion.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define module_name Digest-SRI
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Calculate and verify Subresource Integrity hashes (SRI)
Group: Development/Perl
License: gpl
URL: https://github.com/haukex/Digest-SRI

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HA/HAUKEX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides functions to calculate and verify Subresource
Integrity hashes (SRI). All of the usage is shown in the
the Synopsis entry elsewhere in this document, with some usage notes here:

=over

=item *

The `sri' and `verify_sri' functions both accept either:

=over

=item *

a filename as a plain scalar,

=item *

a filehandle as a reference to a glob, or

=item *

a string of data as a reference to a scalar.

=back

=item *

`Digest::SRI->new' accepts either:

=over

=item *

no argument, which will use the "strongest" hashing algorithm
(currently SHA-512),

=item *

the strings `"SHA-256"', `"SHA-384"', or `"SHA-512"' (or
variants thereof, such as `"SHA256"' or `"sha512"') to specify
those algorithms, or

=item *

a string representing a Subresource Integrity hash, which is to be
used for later verification with `->verify'.

=item *

Some other hashing algorithms, such as `"MD5"', are currently
accepted, but known-weak hashing algorithms are *not* recommended
by the W3C spec and they may be rejected by browsers.

=back

=item *

The methods `->sri' and `->verify' are destructive
operations, meaning the state of the underlying the Digest manpage object
will be reset once you call one of these methods.

=item *

The other methods provided by the the Digest manpage family of modules,
such as `reset' and `clone', are also provided by this module.

=item *

Differences in Base64 padding (`=') are currently ignored on
verification, but future versions of this module *may* add
warnings if this is deemed necessary.

=back

This documentation describes version 0.02 of this module.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE.txt
%perl_vendor_privlib/D*

%changelog
