# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Directory/Iterator/XS.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Directory-Iterator
%define upstream_version 1.001

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_10

Summary:    Simple, efficient recursive directory listing 
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Directory/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Directory/Iterator/PP.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildArch:  noarch
Source44: import.info

%description
This is a simple, efficient way to get a recursive list of all files under
a specified directory.

It implements a typical iterator interface, making it simple to convert
code that processes a list of files to use this instead. The directory is
read as the list is consumed, so memory overhead is minimal.

This module simply loads the appropriate backend; either the
Directory::Iterator::PP manpage or the Directory::Iterator::XS manpage.
With the pure-perl backend, the speed is equivalent to the File::Find
manpage; the XS backend is a few times faster.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml  README
%perl_vendor_privlib/*


%changelog
